/*
 * Decompiled with CFR 0.152.
 */
package ddf.mimin.javasound;

import ddf.mimin.javasound.BasicMetaData;
import ddf.mimin.javasound.JSMinim;
import ddf.mimin.javasound.JSPCMAudioRecordingStream;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.SampleRecorder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.FloatSampleBuffer;

final class JSBufferedSampleRecorder
implements SampleRecorder {
    private ArrayList buffers;
    private FloatBuffer left;
    private FloatBuffer right;
    private boolean recording;
    private String name;
    private AudioFileFormat.Type type;
    private AudioFormat format;
    private JSMinim system;

    JSBufferedSampleRecorder(JSMinim sys, String fileName, AudioFileFormat.Type fileType, AudioFormat fileFormat, int bufferSize) {
        this.name = fileName;
        this.type = fileType;
        this.format = fileFormat;
        this.buffers = new ArrayList(20);
        this.left = FloatBuffer.allocate(bufferSize * 10);
        this.right = this.format.getChannels() == 2 ? FloatBuffer.allocate(bufferSize * 10) : null;
        this.system = sys;
    }

    public String filePath() {
        return this.name;
    }

    public AudioRecordingStream save() {
        if (this.isRecording()) {
            this.system.error("You must stop recording before you can write to a file.");
        } else {
            int offset;
            int i;
            int channels = this.format.getChannels();
            int length = this.left.capacity();
            int totalSamples = this.buffers.size() / channels * length;
            FloatSampleBuffer fsb = new FloatSampleBuffer(channels, totalSamples, this.format.getSampleRate());
            if (channels == 1) {
                i = 0;
                while (i < this.buffers.size()) {
                    offset = i * length;
                    FloatBuffer fb = (FloatBuffer)this.buffers.get(i);
                    fb.rewind();
                    fb.get(fsb.getChannel(0), offset, length);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.buffers.size()) {
                    offset = i / 2 * length;
                    FloatBuffer fbL = (FloatBuffer)this.buffers.get(i);
                    FloatBuffer fbR = (FloatBuffer)this.buffers.get(i + 1);
                    fbL.rewind();
                    fbL.get(fsb.getChannel(0), offset, length);
                    fbR.rewind();
                    fbR.get(fsb.getChannel(1), offset, length);
                    i += 2;
                }
            }
            int sampleFrames = fsb.getByteArrayBufferSize(this.format) / this.format.getFrameSize();
            ByteArrayInputStream bais = new ByteArrayInputStream(fsb.convertToByteArray(this.format));
            AudioInputStream ais = new AudioInputStream(bais, this.format, sampleFrames);
            if (AudioSystem.isFileTypeSupported(this.type, ais)) {
                File out = new File(this.name);
                try {
                    AudioSystem.write(ais, this.type, out);
                }
                catch (IOException e) {
                    this.system.error("AudioRecorder.save: Error attempting to save buffer to " + this.name + "\n" + e.getMessage());
                }
                if (out.length() == 0L) {
                    this.system.error("AudioRecorder.save: Error attempting to save buffer to " + this.name + ", the output file is empty.");
                }
            } else {
                this.system.error("AudioRecorder.save: Can't write " + this.type.toString() + " using format " + this.format.toString() + ".");
            }
        }
        String filePath = this.filePath();
        AudioInputStream ais = this.system.getAudioInputStream(filePath);
        SourceDataLine sdl = this.system.getSourceDataLine(ais.getFormat(), 1024);
        long length = AudioUtils.frames2Millis((long)ais.getFrameLength(), (AudioFormat)this.format);
        BasicMetaData meta = new BasicMetaData(filePath, length);
        JSPCMAudioRecordingStream recording = new JSPCMAudioRecordingStream(this.system, meta, ais, sdl, 1024);
        return recording;
    }

    public void samples(float[] samp) {
        if (this.recording) {
            this.left.put(samp);
            if (!this.left.hasRemaining()) {
                this.buffers.add(this.left);
                this.left = FloatBuffer.allocate(this.left.capacity());
            }
        }
    }

    public void samples(float[] sampL, float[] sampR) {
        if (this.recording) {
            this.left.put(sampL);
            this.right.put(sampR);
            if (!this.left.hasRemaining()) {
                this.buffers.add(this.left);
                this.buffers.add(this.right);
                this.left = FloatBuffer.allocate(this.left.capacity());
                this.right = FloatBuffer.allocate(this.right.capacity());
            }
        }
    }

    public void beginRecord() {
        this.recording = true;
    }

    public void endRecord() {
        this.recording = false;
    }

    public boolean isRecording() {
        return this.recording;
    }
}

