/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioSignal;
import java.util.HashSet;
import java.util.Vector;

public class SignalChain
implements AudioSignal {
    private Vector signals = new Vector();
    private HashSet enabled = new HashSet();

    public synchronized void add(AudioSignal signal) {
        this.signals.add(signal);
        this.enabled.add(signal);
    }

    public synchronized void remove(AudioSignal signal) {
        this.signals.remove(signal);
        this.enabled.remove(signal);
    }

    public synchronized AudioSignal remove(int i) {
        AudioSignal s = (AudioSignal)this.signals.remove(i);
        this.enabled.remove(s);
        return s;
    }

    public synchronized AudioSignal get(int i) {
        return (AudioSignal)this.signals.get(i);
    }

    public synchronized boolean contains(AudioSignal s) {
        return this.signals.contains(s);
    }

    public synchronized void enable(int i) {
        this.enabled.add(this.get(i));
    }

    public synchronized void enable(AudioSignal signal) {
        if (this.signals.contains(signal)) {
            this.enabled.add(signal);
        }
    }

    public synchronized void enableAll() {
        this.enabled.addAll(this.signals);
    }

    public synchronized boolean hasEnabled() {
        return this.enabled.size() > 0;
    }

    public synchronized boolean isEnabled(AudioSignal signal) {
        return this.enabled.contains(signal);
    }

    public synchronized void disable(int i) {
        this.enabled.remove(this.get(i));
    }

    public synchronized void disable(AudioSignal signal) {
        this.enabled.remove(signal);
    }

    public synchronized void disableAll() {
        this.enabled.clear();
    }

    public synchronized int size() {
        return this.signals.size();
    }

    public synchronized void clear() {
        this.signals.clear();
        this.enabled.clear();
    }

    public synchronized void generate(float[] signal) {
        float[] tmp = new float[signal.length];
        int i = 0;
        while (i < this.signals.size()) {
            AudioSignal s = (AudioSignal)this.signals.get(i);
            if (this.enabled.contains(s)) {
                s.generate(tmp);
                int j = 0;
                while (j < signal.length) {
                    int n = j;
                    signal[n] = signal[n] + tmp[j];
                    ++j;
                }
            }
            ++i;
        }
    }

    public synchronized void generate(float[] left, float[] right) {
        float[] tmpR = new float[left.length];
        float[] tmpL = new float[right.length];
        int i = 0;
        while (i < this.signals.size()) {
            AudioSignal s = (AudioSignal)this.signals.get(i);
            if (this.enabled.contains(s)) {
                s.generate(tmpL, tmpR);
                int j = 0;
                while (j < left.length) {
                    int n = j;
                    left[n] = left[n] + tmpL[j];
                    int n2 = j;
                    right[n2] = right[n2] + tmpR[j];
                    ++j;
                }
            }
            ++i;
        }
    }
}

